/* 
 * sigaction.c 
 *
 * Виводить відповідне повідомлення, коли отримує сигнал SIGTERM,
 * протягом деякого часу ігнорує сигнали SIGINT, SIGQUIT, після
 * чого відновлює системний обробник сигналів SIGINT, SIGQUIT.
 * Ілюструє порядок організації асинхронної обробки сигналів
 * (функція sigaction()).
 *
 */

#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


/* Обробник сигналу SIGTERM */
void sigterm_handler(int signo)
{
        write(STDOUT_FILENO, "Отримано сигнал SIGTERM.\n", 38);
        _exit(EXIT_FAILURE);
}

int main()
{
        struct sigaction act, oact_int, oact_quit;
        int i;

        printf("Привіт, мій PID дорівнює %d.\n", (int) getpid());

        /* Визначає нову диспозицію для сигналу SIGTERM. */
        memset(&act, 0, sizeof(act));
        act.sa_handler = sigterm_handler;
        if (sigaction(SIGTERM, &act, NULL) != 0) {
                fprintf(stderr, "Помилка при спробі встановити диспозицію"
                                " сигналу SIGTERM: %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }
        /* Оголошує ігнорування сигналів SIGINT та SIGQUIT. */
        act.sa_handler = SIG_IGN;
        if ((sigaction(SIGINT, &act, &oact_int) != 0) 
                || (sigaction(SIGQUIT, &act, &oact_quit))) {
                fprintf(stderr, "Помилка при спробі встановити диспозицію"
                                " сигналу SIGINT або SIGQUIT: %s\n",
                                                        strerror(errno));
                exit(EXIT_FAILURE);
        }

        for (i = 1; i <= 5; i++) {
                sleep(1);
                printf("%d\n", i);
        }
        printf("\n");

        /* Відновлює попередню диспозицію сигналів SIGINT та SIGQUIT. */
        if ((sigaction(SIGINT, &oact_int, NULL) != 0)
                || (sigaction(SIGQUIT, &oact_quit, NULL) != 0)) {
                fprintf(stderr, "Помилка при спробі встановити диспозицію"
                                " сигналу SIGINT або SIGQUIT: %s.\n",
                                                        strerror(errno));
                exit(EXIT_FAILURE);
        }

        for (i = 1; ; i++) {
                sleep(1);
                printf("%d\n", i);
        }

        exit(EXIT_SUCCESS);
}
